clc; clear all; close all; clear figure;

%otevreni serioveho portu
s = serial('COM9');
fopen(s);

%------ZADANA VLHKOST-------------
zadana = 40;

%definice promennych
cov = diag([10,10,10]);
humidity = 0;
old_humidity = 0;
oldold_humidity = 0;
kp = 10;
ti = 0,4;
td = 0,4;
kp_par = kp;
td_par = td;
ti_par = ti;
t0 = 2;
regulacni_zasah = 0;
old_odchylka = 0;
oldold_odchylka = 0;
old_regulacni_zasah = 0;
old_regulacni_zasah_par = 0;
pocet_cyklu = 1;
q = 0.9;
vekt_par = zeros(3,1);
vekt_dat = zeros(3,1);
pom_skal = 0;
chyba_predikce = 0;
epsilon = 0;
eta = 0;
zapominani = 1;
v = 0.000001;
lambda = 0.001;
ro = 0.99;

%pouze pomocne pro vypis


%definice pocatecnich hodnot vektoru parametru
vekt_par = [-(1 + 2 * td / t0) / (1 + t0 / ti + td / t0); 
            td / (t0 + t0 * t0 / ti + td); 
            q / (kp + kp * t0 / ti + kp * td / t0);];


tic;
%regulacni cyklus
for im=1:40
    
    %pomocna promena pro omezeni parametru b_1
    b1 = vekt_par(3);   
    
    %nacteni dat ze serioveho portu
    prijato = fscanf(s);
    
    %preveden retezce z portu na vektor hodnot [humidity water flow ]
    data = hodnoty(prijato);
    
    humidity = data(1);
    waterON = data(2);
    flow = data(3);

    %vypocet odchylky
    odchylka = humidity - zadana;
    
    %cyklus pro start algoritmu, tdy nemame dostatek hodnot pro samocinnou
    %regulaci
    if (pocet_cyklu < 5)
        pocet_cyklu = pocet_cyklu + 1;
        regulacni_zasah = kp*(odchylka - old_odchylka + odchylka * t0 / ti + (odchylka - 2 * old_odchylka + oldold_odchylka) * td / t0) + old_regulacni_zasah;
    else
    %samocinna cast regulace
    
        pocet_cyklu = pocet_cyklu + 1;
        
        %aktualizace vektoru dat
        vekt_dat = [-old_humidity; -oldold_humidity; old_regulacni_zasah_par;];
         
        %aktualizace pomocneho skalaru
        pom_skal = vekt_dat' * cov * vekt_dat;
        
        %chyba_predikce = old_humidity - vekt_par' * old_vekt_dat;
        chyba_predikce = humidity - vekt_par' * vekt_dat;
        
        %aktualizace vektor parametru
        vekt_par = vekt_par + cov * vekt_dat * chyba_predikce /(1 + pom_skal);
        
        %omezeni parametru b_1
        if ((vekt_par(3) < 0.05) && (vekt_par(3) > - 0.05))
            vekt_par(3) = b1
            pocet_cyklu
        end        
        
        %aktualizace faktoru zapominani
        eta = chyba_predikce * chyba_predikce / lambda;
        zapominani = 1 / (1 + (1 + ro) * (log(1 + pom_skal)) + ((v + 1) * eta / (1 + pom_skal + eta) - 1) * pom_skal / (1 + pom_skal));
        v = zapominani * (v + 1);
        lambda = zapominani * (lambda + chyba_predikce * chyba_predikce / (1 + pom_skal));
        
        %aktualizace kovariantni matice
        if (pom_skal > 0)
        
           epsilon = zapominani - (1 - zapominani) / pom_skal;
           cov = cov + cov * vekt_dat * vekt_dat' * cov /(1/epsilon + pom_skal);
        end
        
        %vypocet konstant regulatoru 
        ti_par = - t0 / (1 / (vekt_par(1) + 2 * vekt_par(2)) + 1 + td_par / t0);        
        td_par = t0 * vekt_par(2) * q / (kp_par * vekt_par(3));
        kp_par = - (vekt_par(1) + 2 * vekt_par(2)) * q / vekt_par(3);        
        ti = abs(ti_par);
        td = abs(td_par);
        kp = abs(kp_par);        
        
        %vypocet regulacniho zasahu
        regulacni_zasah = kp*(odchylka - old_odchylka + odchylka * t0 / ti + (odchylka - 2 * old_odchylka + oldold_odchylka) * td / t0) + old_regulacni_zasah;

        
    end
    oldold_odchylka = old_odchylka;
    old_odchylka = odchylka;
    oldold_humidity = old_humidity;
    old_humidity = humidity;
    
    neom_regulacni_zasah = regulacni_zasah;
    
    %omezen aknho zsahu
    if regulacni_zasah > 180, regulacni_zasah = 180; end
    if regulacni_zasah < -180, regulacni_zasah = -180; end 
    
    %aktualizace regulacniho zasahu
     old_regulacni_zasah = regulacni_zasah;  
     
    %aktualizace regulacniho zasahu pro identifikaci 
     old_regulacni_zasah_par = abs(regulacni_zasah);
     
    %pevod aknho zsahu na int
    flow = int16(regulacni_zasah);
    
    %nastaven vody nebo dusku
    if flow < 0
        if waterON == 0
            fprintf(s,'Valves:Water'); 
        end
        fprintf(s,['ServoA:moveTo_',num2str(-flow)]);
    else
        if waterON == 1
            fprintf(s,'Valves:Air'); 
        end
        fprintf(s,['ServoA:moveTo_',num2str(flow)]);
    end
    
    %vektory pro vykresleni grafu
    if im == 1
        Vhumidity=[humidity];
        Vregulacni_zasah=[regulacni_zasah];
        Vtime=[toc];
        Vodchylka=[odchylka];
        Vpar1=[vekt_par(1)];
        Vpar2=[vekt_par(2)];
        Vpar3=[vekt_par(3)];
        Vkp=[kp];
        Vti=[ti];
        Vtd=[td];
        Vneom_regulacni_zasah=[neom_regulacni_zasah];
        Vwater=[waterON];
    else
        Vhumidity=[Vhumidity,humidity];
        Vregulacni_zasah=[Vregulacni_zasah,regulacni_zasah];
        Vtime=[Vtime,toc];
        Vodchylka=[Vodchylka,odchylka];
        Vpar1=[Vpar1,vekt_par(1)];
        Vpar2=[Vpar2,vekt_par(2)];
        Vpar3=[Vpar3,vekt_par(3)];   
        Vkp=[Vkp,kp];
        Vti=[Vti,ti];
        Vtd=[Vtd,td];     
        Vneom_regulacni_zasah=[Vneom_regulacni_zasah,neom_regulacni_zasah];
        Vwater=[Vwater,waterON];
    end  

   %vykresleni grafu
     fig = figure(1);
  set(fig,'units','normalized','outerposition',[0 0 1 1]);
    subplot(321)
    plot(Vtime,Vhumidity,'b-o');
    title('Humidity')
    ylabel('RH');

    %axis([0 3 0 80]);
    subplot(323)
    plot(Vtime,Vregulacni_zasah,'-o');
    title('Regulacni zasah')
    ylabel('Zasah');
    %axis([0 3 -180 180]);
    %hold on;
    subplot(325)
    plot(Vtime,Vodchylka,'-o');
    title('odchylka')
    ylabel('odchylka');
    %axis([0 3 -180 180]);
    %hold on;
    
    subplot(322)
    plot(Vtime,Vpar1,'b-o',Vtime,Vpar2,'k-o',Vtime,Vpar3,'r-o');
    title('Parametry')
    legend('a1', 'a2', 'b1')
    ylabel('a1,a2,a3');
    %hold on;
    %axis([0 3 -10 10]);
    subplot(324)
    plot(Vtime,Vkp,'b-o',Vtime,Vti,'k-o',Vtime,Vtd,'r-o');
    title('kp,ti,td')
    legend('kp', 'ti', 'td')
    ylabel('kp,ti,td');
    %axis([0 3 -10 10]);
    %hold on;
    subplot(326)
    plot(Vtime,Vneom_regulacni_zasah,'-o');
    title('Neovlivneny zasah')
    ylabel('Zasah');
    %axis([0 3 -180 180]);
    %hold on;
    pause(0.5);

end
%zavreni ventilu
fprintf(s,['ServoA:moveTo_',num2str(0)]);
fclose(s);
